{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module System.Curry_CurryPath
  ( d_C_splitProgramName
  , d_C_splitValidProgramName
  , d_C_isValidModuleName
  , d_C_runModuleAction
  , nd_C_runModuleAction
  , d_C_runModuleActionQuiet
  , nd_C_runModuleActionQuiet
  , d_C_splitModuleFileName
  , d_C_splitModuleIdentifiers
  , d_C_joinModuleIdentifiers
  , d_C_stripCurrySuffix
  , d_C_modNameToPath
  , d_C_currySubdir
  , d_C_inCurrySubdir
  , d_C_inCurrySubdirModule
  , d_C_addCurrySubdir
  , d_C_sysLibPath
  , d_C_getLoadPathForModule
  , d_C_lookupModuleSourceInLoadPath
  , d_C_lookupModuleSource
  , d_C_curryModulesInDirectory
  , d_C_curryrcFileName
  , d_C_getPackageVersionOfModule
  , d_C_getPackageVersionOfDirectory
  , d_C_setCurryPath
  , d_C_setCurryPathIfNecessary
  , d_C_packageSpecFile )
  where

import Basics
import qualified Control.Curry_Applicative
import qualified Control.Curry_Monad
import qualified Curry.Compiler.Curry_Distribution
import qualified Data.Curry_List
import qualified Data.Curry_PropertyFile
import qualified Data.Curry_Time
import qualified Curry_Prelude
import qualified System.Curry_Directory
import qualified System.Curry_Environment
import qualified System.Curry_FilePath
import qualified System.Curry_IOExts
import qualified System.Curry_Path


d_C_splitProgramName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitProgramName x1 cd cs = let x2 = System.Curry_FilePath.d_C_splitPath
                                      (d_C_stripCurrySuffix x1 cd cs) cd cs
  in d_C__case_29 x2 (Curry_Prelude.d_C_null x2 cd cs) cd cs

d_C_splitValidProgramName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitValidProgramName x1 cd cs = let x2 = d_C_splitProgramName x1 cd cs
                                         x3 = d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir
                                           x2 cd cs
                                         x4 = d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname
                                           x2 cd cs
  in d_C__case_26 x4 x3 x1 (Curry_Prelude.d_C_null x4 cd cs) cd cs

d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir l cd cs)
    (d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitValidProgramName_dot_uscore_hash_selFP2_hash_dir e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.splitValidProgramName._#selFP2#dir" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.splitValidProgramName._#selFP2#dir" (showCons x1))

d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname l cd cs)
    (d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitValidProgramName_dot_uscore_hash_selFP3_hash_mname e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.splitValidProgramName._#selFP3#mname" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.splitValidProgramName._#selFP3#mname" (showCons x1))

d_C_isValidModuleName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isValidModuleName cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_all
  d_OP_isValidModuleName_dot_isModId_dot_8 cd cs) (Data.Curry_List.d_C_split
  (Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.C_Char '.'#))) cd cs

d_OP_isValidModuleName_dot_isModId_dot_8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isValidModuleName_dot_isModId_dot_8 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_isAlpha x2 cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_all
    d_OP_isValidModuleName_dot_isModId_dot_8_dot_uscore_hash_lambda1 cd cs) x3
    cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_isValidModuleName_dot_isModId_dot_8 l cd cs)
    (d_OP_isValidModuleName_dot_isModId_dot_8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_isValidModuleName_dot_isModId_dot_8 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_isValidModuleName_dot_isModId_dot_8 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath.isValidModuleName.isModId.8" [show x1] info)
  _ -> failCons cd (consFail "System.CurryPath.isValidModuleName.isModId.8"
    (showCons x1))

d_OP_isValidModuleName_dot_isModId_dot_8_dot_uscore_hash_lambda1 :: Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isValidModuleName_dot_isModId_dot_8_dot_uscore_hash_lambda1 x1 cd cs =
  Curry_Prelude.d_OP_bar_bar (Curry_Prelude.d_C_isAlphaNum x1 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  x1 cd cs) (Curry_Prelude.toCurryString "_'") cd cs) cd cs

d_C_runModuleAction :: Cover -> ConstStore -> forall t0 . (Curry_Prelude.Curry
  t0) => (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_runModuleAction cd cs = acceptCs id (d_C_runModuleActionWith
  Curry_Prelude.C_False)

nd_C_runModuleAction :: IDSupply -> Cover -> ConstStore
  -> forall t0 . (Curry_Prelude.Curry t0) => Func (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.C_IO t0)) (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.C_IO t0))
nd_C_runModuleAction s cd cs = wrapDX (wrapNX id) (acceptCs id
  (nd_C_runModuleActionWith Curry_Prelude.C_False))

d_C_runModuleActionQuiet :: Cover -> ConstStore
  -> forall t0 . (Curry_Prelude.Curry t0) => (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO t0
d_C_runModuleActionQuiet cd cs = acceptCs id (d_C_runModuleActionWith
  Curry_Prelude.C_True)

nd_C_runModuleActionQuiet :: IDSupply -> Cover -> ConstStore
  -> forall t0 . (Curry_Prelude.Curry t0) => Func (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.C_IO t0)) (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.C_IO t0))
nd_C_runModuleActionQuiet s cd cs = wrapDX (wrapNX id) (acceptCs id
  (nd_C_runModuleActionWith Curry_Prelude.C_True))

d_C_runModuleActionWith :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> (Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_runModuleActionWith x1 x2 x3 cd cs = let x4 = d_C_splitValidProgramName x3
                                               cd cs
                                             x5 = d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir
                                               x4 cd cs
                                             x6 = d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname
                                               x4 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_getCurrentDirectory cd cs) cd cs)
  (d_OP_runModuleActionWith_dot_uscore_hash_lambda4 x1 x6 x5 x2) cd cs

nd_C_runModuleActionWith :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.C_IO t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  t0
nd_C_runModuleActionWith x1 x2 x3 s cd cs = let s4 = s
  in s4 `seq` (let x4 = d_C_splitValidProgramName x3 cd cs
                   x5 = d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir
                     x4 cd cs
                   x6 = d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname
                     x4 cd cs
  in let s3 = leftSupply s4
         s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (System.Curry_Directory.d_C_getCurrentDirectory cd cs) s1 cd cs))
  (wrapNX id (nd_OP_runModuleActionWith_dot_uscore_hash_lambda4 x1 x6 x5 x2)) s3
  cd cs))

d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir l cd cs)
    (d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_runModuleActionWith_dot_uscore_hash_selFP5_hash_progdir e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.runModuleActionWith._#selFP5#progdir" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.runModuleActionWith._#selFP5#progdir" (showCons x1))

d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname l cd cs)
    (d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_runModuleActionWith_dot_uscore_hash_selFP6_hash_mname e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.runModuleActionWith._#selFP6#mname" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.runModuleActionWith._#selFP6#mname" (showCons x1))

d_OP_runModuleActionWith_dot_uscore_hash_lambda4 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO t0
d_OP_runModuleActionWith_dot_uscore_hash_lambda4 x1 x2 x3 x4 x5 cd cs =
  let x6 = x5
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_OP_dollar (Control.Curry_Monad.d_C_unless
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  x3 (Curry_Prelude.toCurryString ".") cd cs)) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_OP_dollar (Control.Curry_Monad.d_C_unless
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash
  x1) (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_putStrLn
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
  "Switching to directory '") (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.toCurryString "'...") cd cs) cd cs) cd cs) cd cs) cd cs)
  (System.Curry_Directory.d_C_setCurrentDirectory x3 cd cs) cd cs) cd cs) cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_apply x4 x2 cd cs) cd cs)
  (d_OP_runModuleActionWith_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 x6
  x3) cd cs) cd cs

nd_OP_runModuleActionWith_dot_uscore_hash_lambda4 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.C_IO t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  t0
nd_OP_runModuleActionWith_dot_uscore_hash_lambda4 x1 x2 x3 x4 x5 s cd cs =
  let s25 = s
  in s25 `seq` (let x6 = x5
  in let s24 = leftSupply s25
         s26 = rightSupply s25
         s15 = leftSupply s26
         s23 = rightSupply s26
  in s24 `seq` (s26 `seq` (s15 `seq` (s23 `seq` Curry_Prelude.nd_C_apply
  (let s14 = leftSupply s15
       s16 = rightSupply s15
       s0 = leftSupply s16
       s12 = rightSupply s16
  in s14 `seq` (s16 `seq` (s0 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (let s11 = leftSupply s12
                 s13 = rightSupply s12
                 s1 = leftSupply s13
                 s10 = rightSupply s13
  in s11 `seq` (s13 `seq` (s1 `seq` (s10 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Control.Curry_Monad.nd_C_unless (wrapNX id
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash)
  (Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  (wrapNX id
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  x3 (Curry_Prelude.toCurryString ".") s1 cd cs))) (let s9 = leftSupply s10
                                                        s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s2 cd cs) (let s4 = leftSupply s5
                 s3 = rightSupply s5
  in s4 `seq` (s3 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
  (Control.Curry_Monad.nd_C_unless (wrapNX id
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash)
  x1)) (Curry_Prelude.nd_OP_dollar (wrapDX id Curry_Prelude.d_C_putStrLn)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
  "Switching to directory '") (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.toCurryString "'...") cd cs) cd cs) s3 cd cs) s4 cd cs)) s6 cd
  cs)))) (System.Curry_Directory.d_C_setCurrentDirectory x3 cd cs) s9 cd cs))
  s11 cd cs)))) s14 cd cs)))) (let s22 = leftSupply s23
                                   s20 = rightSupply s23
  in s22 `seq` (s20 `seq` Curry_Prelude.nd_C_apply (let s19 = leftSupply s20
                                                        s21 = rightSupply s20
                                                        s17 = leftSupply s21
                                                        s18 = rightSupply s21
  in s19 `seq` (s21 `seq` (s17 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s17 cd cs) (Curry_Prelude.nd_C_apply x4 x2 s18 cd cs) s19 cd cs)))) (wrapDX id
  (d_OP_runModuleActionWith_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 x6
  x3)) s22 cd cs)) s24 cd cs))))

d_OP_runModuleActionWith_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_OP_runModuleActionWith_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_OP_dollar (Control.Curry_Monad.d_C_unless
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  x2 (Curry_Prelude.toCurryString ".") cd cs))
  (System.Curry_Directory.d_C_setCurrentDirectory x1 cd cs) cd cs) cd cs)
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x4 cd cs) cd cs

d_C_splitModuleFileName :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitModuleFileName x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply
                                            (d_C_splitModuleIdentifiers cd cs)
                                            x1 cd cs
  in d_C__case_23 x2 x3 cd cs

d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.splitModuleFileName._#selFP11#base" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.splitModuleFileName._#selFP11#base" (showCons x1))

d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.splitModuleFileName._#selFP12#ext" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.splitModuleFileName._#selFP12#ext" (showCons x1))

d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.splitModuleFileName._#selFP9#pre" [show x1] info)
  _ -> failCons cd (consFail "System.CurryPath.splitModuleFileName._#selFP9#pre"
    (showCons x1))

d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.splitModuleFileName._#selFP10#suf" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.splitModuleFileName._#selFP10#suf" (showCons x1))

d_C_splitModuleIdentifiers :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitModuleIdentifiers cd cs = Data.Curry_List.d_C_split
  (Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.C_Char '.'#))

d_C_joinModuleIdentifiers :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_joinModuleIdentifiers cd cs = Curry_Prelude.d_C_foldr1 (acceptCs id
  d_OP_joinModuleIdentifiers_dot_combine_dot_39)

d_OP_joinModuleIdentifiers_dot_combine_dot_39 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_joinModuleIdentifiers_dot_combine_dot_39 x1 x2 cd cs =
  Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
  '.'#) x2) cd cs

d_C_stripCurrySuffix :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_stripCurrySuffix x1 cd cs = d_C__case_19 x1 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_C_takeExtension cd cs) x1 cd
  cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString ".curry")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString ".lcurry")
  Curry_Prelude.OP_List)) cd cs) cd cs

d_C_modNameToPath :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_modNameToPath cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_foldr1
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)) (Data.Curry_List.d_C_split
  (Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.C_Char '.'#))) cd cs

d_C_currySubdir :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_currySubdir cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Prelude.toCurryString
  ".curry") cd cs) (Curry_Prelude.d_OP_plus_plus
  (Curry.Compiler.Curry_Distribution.d_C_curryCompiler cd cs)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "-")
  (Data.Curry_List.d_C_intercalate (Curry_Prelude.toCurryString ".")
  (Curry_Prelude.d_C_map
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int_hash
  cd cs) (Curry_Prelude.OP_Cons
  (Curry.Compiler.Curry_Distribution.d_C_curryCompilerMajorVersion cd cs)
  (Curry_Prelude.OP_Cons
  (Curry.Compiler.Curry_Distribution.d_C_curryCompilerMinorVersion cd cs)
  (Curry_Prelude.OP_Cons
  (Curry.Compiler.Curry_Distribution.d_C_curryCompilerRevisionVersion cd cs)
  Curry_Prelude.OP_List))) cd cs) cd cs) cd cs) cd cs) cd cs

d_C_inCurrySubdir :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_inCurrySubdir x1 cd cs = let x2 = System.Curry_FilePath.d_C_splitFileName x1
                                   cd cs
                                 x3 = d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base
                                   x2 cd cs
                                 x4 = d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file
                                   x2 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x3 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) (d_C_currySubdir cd cs) cd cs)
  (Curry_Prelude.d_C_apply (d_C_modNameToPath cd cs) x4 cd cs) cd cs) cd cs

d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base l cd cs)
    (d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_inCurrySubdir_dot_uscore_hash_selFP14_hash_base e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.inCurrySubdir._#selFP14#base" [show x1] info)
  _ -> failCons cd (consFail "System.CurryPath.inCurrySubdir._#selFP14#base"
    (showCons x1))

d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file l cd cs)
    (d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_inCurrySubdir_dot_uscore_hash_selFP15_hash_file e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.inCurrySubdir._#selFP15#file" [show x1] info)
  _ -> failCons cd (consFail "System.CurryPath.inCurrySubdir._#selFP15#file"
    (showCons x1))

d_C_inCurrySubdirModule :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_inCurrySubdirModule x1 x2 cd cs = let x3 = d_C_splitModuleFileName x1 x2 cd
                                            cs
                                          x4 = d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP
                                            x3 cd cs
                                          x5 = d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP
                                            x3 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x4 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) (d_C_currySubdir cd cs) cd cs)
  x5 cd cs) cd cs

d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP l cd cs)
    (d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_inCurrySubdirModule_dot_uscore_hash_selFP17_hash_dirP e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.inCurrySubdirModule._#selFP17#dirP" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.inCurrySubdirModule._#selFP17#dirP" (showCons x1))

d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP l cd cs)
    (d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_inCurrySubdirModule_dot_uscore_hash_selFP18_hash_modP e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.inCurrySubdirModule._#selFP18#modP" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.inCurrySubdirModule._#selFP18#modP" (showCons x1))

d_C_addCurrySubdir :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_addCurrySubdir x1 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x1 cd cs) (d_C_currySubdir cd
  cs) cd cs

d_C_sysLibPath :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_sysLibPath cd cs =
  let x1 = Curry.Compiler.Curry_Distribution.d_C_curryCompiler cd cs
  in d_C__case_18 x1 (Curry_Prelude.d_C_eqString x1 (Curry_Prelude.toCurryString
  "kmcc") cd cs) cd cs

d_C_getLoadPathForModule :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getLoadPathForModule x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_curryrcFileName cd cs) cd cs)
  (d_OP_getLoadPathForModule_dot_uscore_hash_lambda13 x1) cd cs

d_OP_getLoadPathForModule_dot_uscore_hash_lambda13 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getLoadPathForModule_dot_uscore_hash_lambda13 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Data.Curry_PropertyFile.d_C_getPropertyFromFile x3
  (Curry_Prelude.toCurryString "libraries") cd cs) cd cs)
  (d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15
  x1) cd cs

d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15 x1 x2 cd cs =
  let x3 = x2
      x4 = Curry_Prelude.d_C_apply (System.Curry_FilePath.d_C_dropFileName cd
        cs) x1 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Environment.d_C_getEnv (Curry_Prelude.toCurryString
  "CURRYPATH") cd cs) cd cs)
  (d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17
  x4 x3) cd cs

d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17 x1 x2 x3 cd cs =
  let x4 = x3
      x5 = Curry_Prelude.d_C_maybe Curry_Prelude.OP_List
        d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19
        x2 cd cs
  in Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.OP_Cons x1 (Curry_Prelude.d_OP_plus_plus (d_C__case_16
  x4 (Curry_Prelude.d_C_null x4 cd cs) cd cs) (Curry_Prelude.d_OP_plus_plus x5
  (d_C_sysLibPath cd cs) cd cs) cd cs)) cd cs

d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_getLoadPathForModule_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19 x1 cd cs =
  d_C__case_15 x1 (Curry_Prelude.d_C_null x1 cd cs) cd cs

d_C_lookupModuleSourceInLoadPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_lookupModuleSourceInLoadPath x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_getLoadPathForModule x1 cd cs) cd cs)
  (d_OP_lookupModuleSourceInLoadPath_dot_uscore_hash_lambda21 x1) cd cs

d_OP_lookupModuleSourceInLoadPath_dot_uscore_hash_lambda21 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_lookupModuleSourceInLoadPath_dot_uscore_hash_lambda21 x1 x2 cd cs =
  let x3 = x2 in d_C_lookupModuleSource x3 x1 cd cs

d_C_lookupModuleSource :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_lookupModuleSource x1 x2 cd cs = let x3 = d_C_stripCurrySuffix x2 cd cs
                                         x4 = Curry_Prelude.d_OP_plus_plus
                                           (Curry_Prelude.d_C_apply
                                           (d_C_modNameToPath cd cs) x3 cd cs)
                                           (Curry_Prelude.toCurryString
                                           ".lcurry") cd cs
                                         x5 = Curry_Prelude.d_OP_plus_plus
                                           (Curry_Prelude.d_C_apply
                                           (d_C_modNameToPath cd cs) x3 cd cs)
                                           (Curry_Prelude.toCurryString
                                           ".curry") cd cs
  in d_C__case_14 x3 x1 x4 x5 (Curry_Prelude.d_C_apply (d_C_isValidModuleName cd
  cs) x3 cd cs) cd cs

d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81 x1 x2 x3 cd cs =
  case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (System.Curry_Directory.d_C_doesFileExist (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x4
    cd cs) x2 cd cs) cd cs) cd cs)
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24
    x4 x1 x2 x5) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81 x1 x2 l cd cs)
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81 x1 x2 e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath.lookupModuleSource.lookupSourceInPath.81" [show x1, show
    x2, show x3] info)
  _ -> failCons cd (consFail
    "System.CurryPath.lookupModuleSource.lookupSourceInPath.81" (showCons x3))

d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24 x1 x2 x3 x4 x5 cd cs =
  case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x1
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x1 cd cs) x3 cd cs))) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (System.Curry_Directory.d_C_doesFileExist (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x1
    cd cs) x2 cd cs) cd cs) cd cs)
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27
    x1 x2 x3 x4) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24
    x1 x2 x3 x4 l cd cs)
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24
    x1 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24
    x1 x2 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x ->
    d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24
    x1 x2 x3 x4 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath.lookupModuleSource.lookupSourceInPath.81._#lambda24" [show
    x1, show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail
    "System.CurryPath.lookupModuleSource.lookupSourceInPath.81._#lambda24"
    (showCons x5))

d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27 x1 x2 x3 x4 x5 cd cs =
  case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x1
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x1 cd cs) x2 cd cs))) cd cs
  Curry_Prelude.C_False -> d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81
    x2 x3 x4 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27
    x1 x2 x3 x4 l cd cs)
    (d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27
    x1 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27
    x1 x2 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x ->
    d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81_dot_uscore_hash_lambda24_dot_uscore_hash_lambda27
    x1 x2 x3 x4 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath.lookupModuleSource.lookupSourceInPath.81._#lambda24._#lambda27"
    [show x1, show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail
    "System.CurryPath.lookupModuleSource.lookupSourceInPath.81._#lambda24._#lambda27"
    (showCons x5))

d_C_curryModulesInDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_curryModulesInDirectory x1 cd cs =
  d_OP_curryModulesInDirectory_dot_getModules_dot_92 Curry_Prelude.OP_List x1 cd
  cs

d_OP_curryModulesInDirectory_dot_isCurryFile_dot_92 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_curryModulesInDirectory_dot_isCurryFile_dot_92 x1 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_C_takeExtension cd cs) x1 cd
  cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString ".curry")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString ".lcurry")
  Curry_Prelude.OP_List)) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92 x1 x2 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_doesDirectoryExist x2 cd cs) cd cs)
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33
  x2 x1) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C__case_13 x1 x4 cd cs) cd cs)
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35
  x1 x2) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35 x1 x2 x3 cd cs =
  let x4 = x3
      x5 = Curry_Prelude.d_C_filter
        d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda37
        x4 cd cs
      x6 = Curry_Prelude.d_C_filter
        d_OP_curryModulesInDirectory_dot_isCurryFile_dot_92 x5 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_mapM
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda38
  x1) cd cs) x5 cd cs) cd cs) (Curry_Prelude.d_OP_dot
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_concat cd cs) cd cs) cd cs) cd cs)
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42
  x1 x2 x6) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda37 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda37 x1 cd cs =
  Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
  cd cs) (Curry_Prelude.d_C_length x1 cd cs) cd cs) (Curry_Prelude.C_Int (1)) cd
  cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  cd cs) (Curry_Prelude.d_C_head x1 cd cs) cd cs) (Curry_Prelude.C_Char '.'#) cd
  cs) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda38 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda38 x1 x2 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_doesDirectoryExist (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x1 cd
  cs) x2 cd cs) cd cs) cd cs)
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda38_dot_uscore_hash_lambda40
  x2) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda38_dot_uscore_hash_lambda40 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda38_dot_uscore_hash_lambda40 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C__case_12 x1 x3 cd cs) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42 x1 x2 x3 x4 cd cs =
  let x5 = x4
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_mapM
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42_dot_uscore_hash_lambda44
  x1 x2) cd cs) x5 cd cs) cd cs)
  (d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42_dot_uscore_hash_lambda45
  x2 x3) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42_dot_uscore_hash_lambda44 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42_dot_uscore_hash_lambda44 x1 x2 x3 cd cs =
  d_OP_curryModulesInDirectory_dot_getModules_dot_92
  (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.toCurryString ".") cd cs) cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x1 cd
  cs) x3 cd cs) cd cs

d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42_dot_uscore_hash_lambda45 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_curryModulesInDirectory_dot_getModules_dot_92_dot_uscore_hash_lambda33_dot_uscore_hash_lambda35_dot_uscore_hash_lambda42_dot_uscore_hash_lambda45 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_map
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_OP_plus_plus x1) d_C_stripCurrySuffix
  cd cs) x2 cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concat cd cs) x4
  cd cs) cd cs) cd cs

d_C_curryrcFileName :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_curryrcFileName cd cs = let x1 = Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
                                  '.'#) (Curry_Prelude.d_OP_plus_plus
                                  (Curry.Compiler.Curry_Distribution.d_C_curryCompiler
                                  cd cs) (Curry_Prelude.toCurryString "rc") cd
                                  cs)
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_getHomeDirectory cd cs) cd cs)
  (Curry_Prelude.d_OP_dot
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_flip (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)
  x1) cd cs) cd cs

d_C_getPackageVersionOfModule :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_getPackageVersionOfModule x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_lookupModuleSourceInLoadPath x1 cd cs) cd cs)
  (d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 x1) cd cs

d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Module '")
    (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.toCurryString
    "' not found in load path!") cd cs) cd cs) cd cs
  Curry_Prelude.C_Just x3 -> d_C__case_11 x3 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i
    (d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 x1 l cd cs)
    (d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z ->
    d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c ((\x ->
    d_OP_getPackageVersionOfModule_dot_uscore_hash_lambda48 x1 e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "System.CurryPath.getPackageVersionOfModule._#lambda48" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "System.CurryPath.getPackageVersionOfModule._#lambda48" (showCons x2))

d_C_getPackageVersionOfDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_getPackageVersionOfDirectory x1 cd cs = d_C__case_10 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (d_C_sysLibPath cd cs) (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs)
  cd cs

d_OP_getPackageVersionOfDirectory_dot_isVersionId_dot_120 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_getPackageVersionOfDirectory_dot_isVersionId_dot_120 x1 cd cs = d_C__case_9
  x1 (Data.Curry_List.d_C_split (Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.C_Char '.'#)) x1 cd cs) cd cs

d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120 x1 x2 cd cs =
  let x3 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_break
        (Curry_Prelude.d_C_flip (acceptCs id
        Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
        (Curry_Prelude.C_Char '-'#)) cd cs) x2 cd cs
      x4 = d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname
        x3 cd cs
      x5 = d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers
        x3 cd cs
      x6 = d_C__case_4 x1 x4 (Curry_Prelude.d_C_null x1 cd cs) cd cs
  in d_C__case_6 x5 x6 (Curry_Prelude.d_C_null x5 cd cs) cd cs

d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname
    l cd cs)
    (d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname
    r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP20_hash_pname
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.getPackageVersionOfDirectory.splitPkgId.120._#selFP20#pname"
    [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.getPackageVersionOfDirectory.splitPkgId.120._#selFP20#pname"
    (showCons x1))

d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers
    l cd cs)
    (d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers
    r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120_dot_uscore_hash_selFP21_hash_hvers
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath.getPackageVersionOfDirectory.splitPkgId.120._#selFP21#hvers"
    [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.getPackageVersionOfDirectory.splitPkgId.120._#selFP21#hvers"
    (showCons x1))

d_OP_getPackageVersionOfDirectory_dot_uscore_hash_lambda52 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getPackageVersionOfDirectory_dot_uscore_hash_lambda52 x1 cd cs =
  d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120 Curry_Prelude.OP_List
  (Data.Curry_List.d_C_last (System.Curry_FilePath.d_C_splitDirectories x1 cd
  cs) cd cs) cd cs

d_C_getPackageSpecPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getPackageSpecPath x1 cd cs =
  d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138
  (System.Curry_FilePath.d_C_splitDirectories x1 cd cs) cd cs

d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (System.Curry_Directory.d_C_doesFileExist
    (System.Curry_FilePath.d_C_joinPath (Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.OP_Cons (d_C_packageSpecFile cd cs) Curry_Prelude.OP_List) cd
    cs) cd cs) cd cs) cd cs)
    (d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54
    x1) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138 l cd cs)
    (d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath.getPackageSpecPath.getPkgSpecPath.138" [show x1] info)
  _ -> failCons cd (consFail
    "System.CurryPath.getPackageSpecPath.getPkgSpecPath.138" (showCons x1))

d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.C_Just (System.Curry_FilePath.d_C_joinPath x1 cd cs))
    cd cs
  Curry_Prelude.C_False -> d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138
    (Data.Curry_List.d_C_init x1 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54
    x1 l cd cs)
    (d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54
    x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x ->
    d_OP_getPackageSpecPath_dot_getPkgSpecPath_dot_138_dot_uscore_hash_lambda54
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath.getPackageSpecPath.getPkgSpecPath.138._#lambda54" [show x1
    , show x2] info)
  _ -> failCons cd (consFail
    "System.CurryPath.getPackageSpecPath.getPkgSpecPath.138._#lambda54"
    (showCons x2))

d_C_setCurryPath :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_setCurryPath x1 x2 cd cs = let x3 = Curry_Prelude.d_OP_dot
                                     (Curry_Prelude.d_C_reverse cd cs)
                                     (Curry_Prelude.d_OP_dot
                                     (Curry_Prelude.d_C_dropWhile
                                     Curry_Prelude.d_C_isSpace)
                                     (Curry_Prelude.d_OP_dot
                                     (Curry_Prelude.d_C_reverse cd cs)
                                     (Curry_Prelude.d_C_dropWhile
                                     Curry_Prelude.d_C_isSpace) cd cs) cd cs) cd
                                     cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Environment.d_C_getEnv (Curry_Prelude.toCurryString
  "CURRYPATH") cd cs) cd cs) (d_OP_setCurryPath_dot_uscore_hash_lambda57 x1 x2
  x3) cd cs

d_OP_setCurryPath_dot_putStrLnNQ_dot_147 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPath_dot_putStrLnNQ_dot_147 x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  (Control.Curry_Monad.d_C_unless
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash
  x1) (Curry_Prelude.d_C_putStrLn x2 cd cs) cd cs

d_OP_setCurryPath_dot_uscore_hash_lambda57 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPath_dot_uscore_hash_lambda57 x1 x2 x3 x4 cd cs = let x5 = x4
  in d_C__case_3 x5 x1 x3 x2 (Curry_Prelude.d_C_null x5 cd cs) cd cs

nd_OP_setCurryPath_dot_uscore_hash_lambda57 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPath_dot_uscore_hash_lambda57 x1 x2 x3 x4 s cd cs = let s0 = s
  in s0 `seq` (let x5 = x4
  in nd_C__case_3 x5 x1 x3 x2 (Curry_Prelude.d_C_null x5 cd cs) s0 cd cs)

d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59 :: Curry_Prelude.C_Bool
  -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59 x1 x2 x3 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_OP_dollar (d_OP_setCurryPath_dot_putStrLnNQ_dot_147
  x1) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
  "Computing CURRYPATH with '") (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.toCurryString "'...") cd cs) cd cs) cd cs) cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_IOExts.d_C_evalCmd x3 (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "deps") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "--path") Curry_Prelude.OP_List))
  Curry_Prelude.OP_List cd cs) cd cs)
  (d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
  x1 x2) cd cs) cd cs

nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59 :: Curry_Prelude.C_Bool
  -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59 x1 x2 x3 s cd cs =
  let s11 = s
  in s11 `seq` (let s10 = leftSupply s11
                    s12 = rightSupply s11
                    s3 = leftSupply s12
                    s9 = rightSupply s12
  in s10 `seq` (s12 `seq` (s3 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
  (let s2 = leftSupply s3
       s4 = rightSupply s3
       s0 = leftSupply s4
       s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (Curry_Prelude.nd_OP_dollar (wrapDX id
  (d_OP_setCurryPath_dot_putStrLnNQ_dot_147 x1)) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "Computing CURRYPATH with '")
  (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.toCurryString "'...") cd cs)
  cd cs) s1 cd cs) s2 cd cs)))) (let s8 = leftSupply s9
                                     s7 = rightSupply s9
  in s8 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s5 = rightSupply s7
  in s6 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s5 cd cs) (System.Curry_IOExts.d_C_evalCmd x3 (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "deps") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "--path") Curry_Prelude.OP_List))
  Curry_Prelude.OP_List cd cs) s6 cd cs)) (wrapNX id
  (nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
  x1 x2)) s8 cd cs)) s10 cd cs))))

d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61 :: Curry_Prelude.C_Bool
  -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61 x1 x2 x3 cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple3 x4 x5 x6 -> d_C__case_1 x4 x6 x5 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    x4 (Curry_Prelude.C_Int (0)) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 l cd cs)
    (d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c ((\x ->
    d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "System.CurryPath.setCurryPath._#lambda57._#lambda59._#lambda61" [show x1
    , show x2, show x3] info)
  _ -> failCons cd (consFail
    "System.CurryPath.setCurryPath._#lambda57._#lambda59._#lambda61" (showCons
    x3))

nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61 :: Curry_Prelude.C_Bool
  -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61 x1 x2 x3 s cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple3 x4 x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_1 x4 x6 x5 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    x4 (Curry_Prelude.C_Int (0)) cd cs) s0 cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 l s cd cs)
    (nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c ((\x ->
    nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59_dot_uscore_hash_lambda61
    x1 x2 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "System.CurryPath.setCurryPath._#lambda57._#lambda59._#lambda61" [show x1
    , show x2, show x3] info)
  _ -> failCons cd (consFail
    "System.CurryPath.setCurryPath._#lambda57._#lambda59._#lambda61" (showCons
    x3))

d_C_setCurryPathIfNecessary :: Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_setCurryPathIfNecessary cd cs = let x1 = d_C_setCurryPath
                                          Curry_Prelude.C_True
                                          Curry_Prelude.OP_List cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Environment.d_C_getEnv (Curry_Prelude.toCurryString
  "CURRYPATH") cd cs) cd cs)
  (d_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76 x1) cd cs

d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157 :: Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157 x1 x2 cd cs =
  let x3 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
        (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x2 cd cs)
        (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
        (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)
        (Curry_Prelude.toCurryString ".cpm") cd cs) (Curry_Prelude.toCurryString
        "CURRYPATH_CACHE") cd cs) cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_doesFileExist x3 cd cs) cd cs)
  (d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
  x3 x2 x1) cd cs

nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157 :: Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157 x1 x2 s cd cs =
  let s12 = s
  in s12 `seq` (let s5 = leftSupply s12
                    s11 = rightSupply s12
  in s5 `seq` (s11 `seq` (let x3 = let s4 = leftSupply s5
                                       s6 = rightSupply s5
                                       s0 = leftSupply s6
                                       s3 = rightSupply s6
                                in s4 `seq` (s6 `seq` (s0 `seq` (s3 `seq`
                                Curry_Prelude.nd_C_apply
                                (Curry_Prelude.nd_C_apply (wrapDX (wrapDX id)
                                (System.Curry_FilePath.d_OP_lt_slash_gt cd cs))
                                x2 s0 cd cs) (let s2 = leftSupply s3
                                                  s1 = rightSupply s3
                                in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
                                (Curry_Prelude.nd_C_apply (wrapDX (wrapDX id)
                                (System.Curry_FilePath.d_OP_lt_slash_gt cd cs))
                                (Curry_Prelude.toCurryString ".cpm") s1 cd cs)
                                (Curry_Prelude.toCurryString "CURRYPATH_CACHE")
                                s2 cd cs)) s4 cd cs)))
  in let s10 = leftSupply s11
         s9 = rightSupply s11
  in s10 `seq` (s9 `seq` Curry_Prelude.nd_C_apply (let s8 = leftSupply s9
                                                       s7 = rightSupply s9
  in s8 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s7 cd cs) (System.Curry_Directory.d_C_doesFileExist x3 cd cs) s8 cd cs))
  (wrapNX id
  (nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
  x3 x2 x1)) s10 cd cs))))

d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (System.Curry_Directory.d_C_getModificationTime x1 cd cs) cd cs)
    (d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68
    x1 x2 x3) cd cs
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 l cd cs)
    (d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x ->
    d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath.setCurryPathIfNecessary.loadCurryPathFromCache.157._#lambda64"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "System.CurryPath.setCurryPathIfNecessary.loadCurryPathFromCache.157._#lambda64"
    (showCons x4))

nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64 x1 x2 x3 x4 s cd cs =
  case x4 of
  Curry_Prelude.C_True -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    s0 cd cs) (System.Curry_Directory.d_C_getModificationTime x1 cd cs) s1 cd
    cs)) (wrapNX id
    (nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68
    x1 x2 x3)) s3 cd cs))
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 l s cd cs)
    (nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x ->
    nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64
    x1 x2 x3 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath.setCurryPathIfNecessary.loadCurryPathFromCache.157._#lambda64"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "System.CurryPath.setCurryPathIfNecessary.loadCurryPathFromCache.157._#lambda64"
    (showCons x4))

d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit -> Data.Curry_Time.C_ClockTime
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68 x1 x2 x3 x4 cd cs =
  let x5 = x4
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_getModificationTime
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x2 cd cs) (d_C_packageSpecFile
  cd cs) cd cs) cd cs) cd cs)
  (d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70
  x5 x1 x3) cd cs

nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit -> Data.Curry_Time.C_ClockTime
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68 x1 x2 x3 x4 s cd cs =
  let s8 = s
  in s8 `seq` (let x5 = x4
  in let s7 = leftSupply s8
         s5 = rightSupply s8
  in s7 `seq` (s5 `seq` Curry_Prelude.nd_C_apply (let s4 = leftSupply s5
                                                      s6 = rightSupply s5
                                                      s0 = leftSupply s6
                                                      s3 = rightSupply s6
  in s4 `seq` (s6 `seq` (s0 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (System.Curry_Directory.d_C_getModificationTime (let s2 = leftSupply
                                                                   s3
                                                                 s1 = rightSupply
                                                                   s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
  (wrapDX (wrapDX id) (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)) x2 s1 cd
  cs) (d_C_packageSpecFile cd cs) s2 cd cs)) cd cs) s4 cd cs)))) (wrapNX id
  (nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70
  x5 x1 x3)) s7 cd cs))

d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70 :: Data.Curry_Time.C_ClockTime
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Data.Curry_Time.C_ClockTime -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70 x1 x2 x3 x4 cd cs =
  let x5 = x4
  in d_C__case_0 x5 x1 x3 x2 (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Data.Curry_Time.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Data_dot_Time_dot_ClockTime_hash
  cd cs) x1 cd cs) x5 cd cs) cd cs

nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70 :: Data.Curry_Time.C_ClockTime
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Data.Curry_Time.C_ClockTime -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70 x1 x2 x3 x4 s cd cs =
  let s4 = s
  in s4 `seq` (let x5 = x4
  in let s3 = leftSupply s4
         s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C__case_0 x5 x1 x3 x2 (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
  (wrapDX (wrapDX id)
  (Data.Curry_Time.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Data_dot_Time_dot_ClockTime_hash
  cd cs)) x1 s0 cd cs) x5 s1 cd cs)) s3 cd cs))

d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70_dot_uscore_hash_lambda73 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70_dot_uscore_hash_lambda73 x1 cd cs =
  let x2 = x1
      x3 = Curry_Prelude.d_C_head (Curry_Prelude.d_C_lines x2 cd cs) cd cs
  in System.Curry_Environment.d_C_setEnv (Curry_Prelude.toCurryString
  "CURRYPATH") x3 cd cs

d_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76 :: Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_OP_dollar (Control.Curry_Applicative.d_C_when
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash
  (Curry_Prelude.d_C_null x3 cd cs)) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Directory.d_C_getCurrentDirectory cd cs) cd cs)
  (d_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76_dot_uscore_hash_lambda79
  x1) cd cs) cd cs

nd_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76 :: Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76 x1 x2 s cd cs =
  let s6 = s
  in s6 `seq` (let x3 = x2
  in let s5 = leftSupply s6
         s4 = rightSupply s6
  in s5 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
  (Control.Curry_Applicative.nd_C_when (wrapNX id
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Applicative_hash_Prelude_dot_IO_hash)
  (Curry_Prelude.d_C_null x3 cd cs))) (let s3 = leftSupply s4
                                           s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (System.Curry_Directory.d_C_getCurrentDirectory cd cs) s1 cd cs))
  (wrapNX id
  (nd_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76_dot_uscore_hash_lambda79
  x1)) s3 cd cs)) s5 cd cs))

d_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76_dot_uscore_hash_lambda79 :: Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76_dot_uscore_hash_lambda79 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_getPackageSpecPath x3 cd cs) cd cs) (Curry_Prelude.d_C_maybe x1
  (d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157 x1)) cd cs

nd_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76_dot_uscore_hash_lambda79 :: Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_OP_setCurryPathIfNecessary_dot_uscore_hash_lambda76_dot_uscore_hash_lambda79 x1 x2 s cd cs =
  let s4 = s
  in s4 `seq` (let x3 = x2
  in let s3 = leftSupply s4
         s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (d_C_getPackageSpecPath x3 cd cs) s1 cd cs)) (wrapNX id
  (Curry_Prelude.nd_C_maybe x1 (wrapNX id
  (nd_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157 x1)))) s3 cd
  cs))

d_C_packageSpecFile :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_packageSpecFile cd cs = Curry_Prelude.toCurryString "package.json"

d_C__case_29 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_29 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString
    ".") Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_28 x2 (Curry_Prelude.d_C_null
    (Curry_Prelude.d_C_tail x2 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_29 x2 l cd cs)
    (d_C__case_29 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_29 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_29 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_29" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_29" (showCons x3))

d_C__case_28 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_28 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString
    ".") (Curry_Prelude.d_C_head x2 cd cs)
  Curry_Prelude.C_False -> d_C__case_27 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_28 x2 l cd cs)
    (d_C__case_28 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_28 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_28 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_28" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_28" (showCons x3))

d_C__case_27 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_27 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concat cd cs) (Data.Curry_List.d_C_init x2 cd cs) cd cs)
    (Data.Curry_List.d_C_last x2 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_27 x2 l cd cs)
    (d_C__case_27 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_27 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_27 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_27" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_27" (showCons x3))

d_C__case_26 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_26 x4 x3 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "The module name is empty.") cd cs
  Curry_Prelude.C_False -> d_C__case_25 x4 x3 x1 (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_apply (d_C_isValidModuleName cd cs) x4 cd cs) cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_26 x4 x3 x1 l cd
    cs) (d_C__case_26 x4 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_26 x4
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_26 x4 x3
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_26" [show x4, show x3, show x1, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_26" (showCons x5))

d_C__case_25 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_25 x4 x3 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "The program name '") (Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.toCurryString "' contains an invalid module name.") cd cs) cd
    cs) cd cs
  Curry_Prelude.C_False -> d_C__case_24 x4 x3 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_25 x4 x3 x1 l cd
    cs) (d_C__case_25 x4 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_25 x4
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_25 x4 x3
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_25" [show x4, show x3, show x1, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_25" (showCons x5))

d_C__case_24 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_24 x4 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x3 x4
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_24 x4 x3 l cd cs)
    (d_C__case_24 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_24 x4
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_24 x4 x3 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_24" [show x4, show x3, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_24" (showCons x5))

d_C__case_23 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_23 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_22 x3 x2 x5 cd cs
  Curry_Prelude.OP_List -> let x16 = System.Curry_FilePath.d_C_splitExtension x2
                                 cd cs
                               x17 = d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base
                                 x16 cd cs
                               x18 = d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext
                                 x16 cd cs
                               x19 = System.Curry_FilePath.d_C_splitDirectories
                                 x17 cd cs
                               x20 = Curry_Prelude.d_C_splitAt
                                 (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
                                 (Curry_Prelude.d_C_length x19 cd cs)
                                 (Curry_Prelude.d_C_length x3 cd cs) cd cs) x19
                                 cd cs
                               x21 = d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre
                                 x20 cd cs
                               x22 = d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf
                                 x20 cd cs
                               x23 = d_C__case_20 x21 (Curry_Prelude.d_C_null
                                 x21 cd cs) cd cs
    in Curry_Prelude.OP_Tuple2 x23 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_dot_gt cd cs)
    (System.Curry_FilePath.d_C_joinPath x22 cd cs) cd cs) x18 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_23 x2 l cd cs)
    (d_C__case_23 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_23 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_23 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath._case_23" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_23" (showCons x3))

d_C__case_20 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_20 x21 x22 cd cs = case x22 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> System.Curry_FilePath.d_C_addTrailingPathSeparator
    (System.Curry_FilePath.d_C_joinPath x21 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x21 l cd cs)
    (d_C__case_20 x21 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x21
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_20 x21 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_20" [show x21, show x22] info)
  _ -> failCons cd (consFail "System.CurryPath._case_20" (showCons x22))

d_C__case_22 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_22 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> System.Curry_FilePath.d_C_splitFileName x2 cd cs
  Curry_Prelude.OP_Cons x6 x7 -> let x8 = System.Curry_FilePath.d_C_splitExtension
                                       x2 cd cs
                                     x9 = d_OP_splitModuleFileName_dot_uscore_hash_selFP11_hash_base
                                       x8 cd cs
                                     x10 = d_OP_splitModuleFileName_dot_uscore_hash_selFP12_hash_ext
                                       x8 cd cs
                                     x11 = System.Curry_FilePath.d_C_splitDirectories
                                       x9 cd cs
                                     x12 = Curry_Prelude.d_C_splitAt
                                       (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
                                       (Curry_Prelude.d_C_length x11 cd cs)
                                       (Curry_Prelude.d_C_length x3 cd cs) cd
                                       cs) x11 cd cs
                                     x13 = d_OP_splitModuleFileName_dot_uscore_hash_selFP9_hash_pre
                                       x12 cd cs
                                     x14 = d_OP_splitModuleFileName_dot_uscore_hash_selFP10_hash_suf
                                       x12 cd cs
                                     x15 = d_C__case_21 x13
                                       (Curry_Prelude.d_C_null x13 cd cs) cd cs
    in Curry_Prelude.OP_Tuple2 x15 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_dot_gt cd cs)
    (System.Curry_FilePath.d_C_joinPath x14 cd cs) cd cs) x10 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_22 x3 x2 l cd
    cs) (d_C__case_22 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_22 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_22 x3 x2
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath._case_22" [show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_22" (showCons x5))

d_C__case_21 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_21 x13 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> System.Curry_FilePath.d_C_addTrailingPathSeparator
    (System.Curry_FilePath.d_C_joinPath x13 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_21 x13 l cd cs)
    (d_C__case_21 x13 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_21 x13
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_21 x13 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_21" [show x13, show x14] info)
  _ -> failCons cd (consFail "System.CurryPath._case_21" (showCons x14))

d_C__case_19 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_19 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_C_dropExtension cd cs) x1 cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_19 x1 l cd cs)
    (d_C__case_19 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_19 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_19 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_19" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.CurryPath._case_19" (showCons x2))

d_C__case_18 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_18 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)
    (Curry.Compiler.Curry_Distribution.d_C_installDir cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Prelude.toCurryString
    "libs") cd cs) (Curry_Prelude.toCurryString "src") cd cs) cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_17 x1 (Curry_Prelude.d_C_eqString x1
    (Curry_Prelude.toCurryString "kics") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_18 x1 l cd cs)
    (d_C__case_18 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_18 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_18 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_18" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.CurryPath._case_18" (showCons x2))

d_C__case_17 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_17 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)
    (Curry.Compiler.Curry_Distribution.d_C_installDir cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Prelude.toCurryString
    "src") cd cs) (Curry_Prelude.toCurryString "lib") cd cs) cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs)
    (Curry.Compiler.Curry_Distribution.d_C_installDir cd cs) cd cs)
    (Curry_Prelude.toCurryString "lib") cd cs) Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_17 x1 l cd cs)
    (d_C__case_17 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_17 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_17 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_17" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.CurryPath._case_17" (showCons x2))

d_C__case_16 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_16 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_C_splitSearchPath cd cs) x4 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x4 l cd cs)
    (d_C__case_16 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x4 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_16 x4 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_16" [show x4, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_16" (showCons x5))

d_C__case_15 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_15 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (System.Curry_FilePath.d_C_splitSearchPath cd cs) x1 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x1 l cd cs)
    (d_C__case_15 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_15 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_15" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.CurryPath._case_15" (showCons x2))

d_C__case_14 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
d_C__case_14 x3 x1 x4 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_OP_lookupModuleSource_dot_lookupSourceInPath_dot_81
    x5 x4 x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x3 x1 x4 x5 l
    cd cs) (d_C__case_14 x3 x1 x4 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x3
    x1 x4 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_14 x3 x1
    x4 x5 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_14" [show x3, show x1, show x4, show x5, show x6]
    info)
  _ -> failCons cd (consFail "System.CurryPath._case_14" (showCons x6))

d_C__case_13 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_13 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> System.Curry_Directory.d_C_getDirectoryContents x1 cd
    cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.OP_List cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x1 l cd cs)
    (d_C__case_13 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_13 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_13" [show x1, show x4] info)
  _ -> failCons cd (consFail "System.CurryPath._case_13" (showCons x4))

d_C__case_12 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_12 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_12 x1 l cd cs)
    (d_C__case_12 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_12 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_12 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_12" [show x1, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_12" (showCons x3))

d_C__case_11 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C__case_11 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> d_C_getPackageVersionOfDirectory x4 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_11 l cd cs)
    (d_C__case_11 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_11 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_11 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.CurryPath._case_11" [show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_11" (showCons x3))

d_C__case_10 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C__case_10 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.toCurryString "base")
    (Curry.Compiler.Curry_Distribution.d_C_baseVersion cd cs))) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_C_getPackageSpecPath x1 cd cs) cd cs) (Curry_Prelude.d_OP_dot
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.d_C_maybe Curry_Prelude.C_Nothing
    d_OP_getPackageVersionOfDirectory_dot_uscore_hash_lambda52) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x1 l cd cs)
    (d_C__case_10 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_10 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_10" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.CurryPath._case_10" (showCons x2))

d_C__case_9 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_9 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_8 x2 x3 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_9 x1 l cd cs)
    (d_C__case_9 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_9 x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_9 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath._case_9" [show x1, show x4] info)
  _ -> failCons cd (consFail "System.CurryPath._case_9" (showCons x4))

d_C__case_8 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_8 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_7 x4 x2 x5 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_8 x2 l cd cs)
    (d_C__case_8 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_8 x2 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_8 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath._case_8" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_8" (showCons x3))

d_C__case_7 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_7 x4 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_all
    (Curry_Prelude.d_C_all Curry_Prelude.d_C_isDigit cd cs) cd cs)
    (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (1)) x6 cd cs)
    Curry_Prelude.OP_List))) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_7 x4 x2 l cd cs)
    (d_C__case_7 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_7 x4
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_7 x4 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.CurryPath._case_7" [show x4, show x2, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_7" (showCons x5))

d_C__case_4 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_4 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> x4
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "-") x4 cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 x4 l cd cs)
    (d_C__case_4 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 x4
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_4 x1 x4 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_4" [show x1, show x4, show x5] info)
  _ -> failCons cd (consFail "System.CurryPath._case_4" (showCons x5))

d_C__case_6 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_6 x5 x6 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Nothing
  Curry_Prelude.C_False -> let x7 = Curry_Prelude.d_C_tail x5 cd cs
    in d_C__case_5 x7 x6
    (d_OP_getPackageVersionOfDirectory_dot_isVersionId_dot_120 x7 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x5 x6 l cd cs)
    (d_C__case_6 x5 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x5 x6
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_6 x5 x6 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_6" [show x5, show x6, show x8] info)
  _ -> failCons cd (consFail "System.CurryPath._case_6" (showCons x8))

d_C__case_5 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_5 x7 x6 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x6 x7)
  Curry_Prelude.C_False -> d_OP_getPackageVersionOfDirectory_dot_splitPkgId_dot_120
    x6 x7 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x7 x6 l cd cs)
    (d_C__case_5 x7 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x7 x6
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_5 x7 x6 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_5" [show x7, show x6, show x8] info)
  _ -> failCons cd (consFail "System.CurryPath._case_5" (showCons x8))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> (Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C__case_3 x5 x1 x3 x2 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_C__case_2 x2 (Curry_Prelude.d_C_null x2 cd cs) cd cs) cd cs)
    (Curry_Prelude.d_C_maybe (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.OP_Unit cd cs)
    (d_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59 x1 x3))
    cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_dollar
    (d_OP_setCurryPath_dot_putStrLnNQ_dot_147 x1) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "CURRYPATH=") x5 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x5 x1 x3 x2 l
    cd cs) (d_C__case_3 x5 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x5 x1
    x3 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_3 x5 x1 x3
    x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_3" [show x5, show x1, show x3, show x2, show x6]
    info)
  _ -> failCons cd (consFail "System.CurryPath._case_3" (showCons x6))

nd_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_C__case_3 x5 x1 x3 x2 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s2 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    s0 cd cs) (d_C__case_2 x2 (Curry_Prelude.d_C_null x2 cd cs) cd cs) s1 cd
    cs)) (wrapNX id (Curry_Prelude.nd_C_maybe (let s4 = leftSupply s5
                                                   s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    s3 cd cs) Curry_Prelude.OP_Unit s4 cd cs)) (wrapNX id
    (nd_OP_setCurryPath_dot_uscore_hash_lambda57_dot_uscore_hash_lambda59 x1
    x3)))) s6 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
    (d_OP_setCurryPath_dot_putStrLnNQ_dot_147 x1)) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "CURRYPATH=") x5 cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_3 x5 x1 x3 x2 l
    s cd cs) (nd_C__case_3 x5 x1 x3 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_3 x5
    x1 x3 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_3 x5 x1
    x3 x2 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_3" [show x5, show x1, show x3, show x2, show x6]
    info)
  _ -> failCons cd (consFail "System.CurryPath._case_3" (showCons x6))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_2 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> System.Curry_Path.d_C_getFileInPath
    (Curry_Prelude.toCurryString "cypm") cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.C_Just x2) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x2 l cd cs)
    (d_C__case_2 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_2 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_2" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.CurryPath._case_2" (showCons x3))

d_C__case_1 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C__case_1 x4 x6 x5 x2 x1 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> let x7 = Curry_Prelude.d_C_apply x2 x5 cd cs
    in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.d_OP_dollar (d_OP_setCurryPath_dot_putStrLnNQ_dot_147
    x1) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "CURRYPATH=")
    x7 cd cs) cd cs) cd cs) (System.Curry_Environment.d_C_setEnv
    (Curry_Prelude.toCurryString "CURRYPATH") x7 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_putStrLn
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "ERROR during computing CURRYPATH with 'cypm':\n")
    (Curry_Prelude.d_OP_plus_plus x5 x6 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x4 x6 x5 x2 x1
    l cd cs) (d_C__case_1 x4 x6 x5 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x4 x6
    x5 x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_1 x4 x6 x5
    x2 x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_1" [show x4, show x6, show x5, show x2, show x1
    , show x8] info)
  _ -> failCons cd (consFail "System.CurryPath._case_1" (showCons x8))

nd_C__case_1 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_C__case_1 x4 x6 x5 x2 x1 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s8 = s
    in s8 `seq` (let s0 = leftSupply s8
                     s7 = rightSupply s8
    in s0 `seq` (s7 `seq` (let x7 = Curry_Prelude.nd_C_apply x2 x5 s0 cd cs
    in let s6 = leftSupply s7
           s4 = rightSupply s7
    in s6 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (let s3 = leftSupply s4
                                                        s5 = rightSupply s4
                                                        s1 = leftSupply s5
                                                        s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    s1 cd cs) (Curry_Prelude.nd_OP_dollar (wrapDX id
    (d_OP_setCurryPath_dot_putStrLnNQ_dot_147 x1)) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "CURRYPATH=") x7 cd cs) s2 cd cs) s3 cd cs))))
    (System.Curry_Environment.d_C_setEnv (Curry_Prelude.toCurryString
    "CURRYPATH") x7 cd cs) s6 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
    Curry_Prelude.d_C_putStrLn) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString
    "ERROR during computing CURRYPATH with 'cypm':\n")
    (Curry_Prelude.d_OP_plus_plus x5 x6 cd cs) cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_1 x4 x6 x5 x2 x1
    l s cd cs) (nd_C__case_1 x4 x6 x5 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_1 x4
    x6 x5 x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_1 x4 x6
    x5 x2 x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_1" [show x4, show x6, show x5, show x2, show x1
    , show x8] info)
  _ -> failCons cd (consFail "System.CurryPath._case_1" (showCons x8))

d_C__case_0 :: Data.Curry_Time.C_ClockTime -> Data.Curry_Time.C_ClockTime
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C__case_0 x5 x1 x3 x2 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (System.Curry_IOExts.d_C_readCompleteFile x2 cd cs) cd cs)
    d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70_dot_uscore_hash_lambda73
    cd cs
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x5 x1 x3 x2 l
    cd cs) (d_C__case_0 x5 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x5 x1
    x3 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x5 x1 x3
    x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_0" [show x5, show x1, show x3, show x2, show x6]
    info)
  _ -> failCons cd (consFail "System.CurryPath._case_0" (showCons x6))

nd_C__case_0 :: Data.Curry_Time.C_ClockTime -> Data.Curry_Time.C_ClockTime
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
nd_C__case_0 x5 x1 x3 x2 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    s0 cd cs) (System.Curry_IOExts.d_C_readCompleteFile x2 cd cs) s1 cd cs))
    (wrapDX id
    d_OP_setCurryPathIfNecessary_dot_loadCurryPathFromCache_dot_157_dot_uscore_hash_lambda64_dot_uscore_hash_lambda68_dot_uscore_hash_lambda70_dot_uscore_hash_lambda73)
    s3 cd cs))
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_0 x5 x1 x3 x2 l
    s cd cs) (nd_C__case_0 x5 x1 x3 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_0 x5
    x1 x3 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_0 x5 x1
    x3 x2 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.CurryPath._case_0" [show x5, show x1, show x3, show x2, show x6]
    info)
  _ -> failCons cd (consFail "System.CurryPath._case_0" (showCons x6))

