{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module System.Curry_Directory
  ( d_C_doesFileExist
  , d_C_doesDirectoryExist
  , d_C_getFileSize
  , d_C_getModificationTime
  , d_C_setCurrentDirectory
  , d_C_getDirectoryContents
  , d_C_createDirectory
  , d_C_createDirectoryIfMissing
  , d_C_removeDirectory
  , d_C_renameDirectory
  , d_C_getHomeDirectory
  , d_C_getTemporaryDirectory
  , d_C_getAbsolutePath
  , d_C_removeFile
  , d_C_renameFile
  , d_C_copyFile
  , d_C_findFileWithSuffix
  , d_C_getFileWithSuffix
  , d_C_getCurrentDirectory )
  where

import Basics
import qualified Data.Curry_List
import qualified Data.Curry_Time
import qualified Curry_Prelude
import qualified System.Curry_Environment
import qualified System.Curry_FilePath

import System.Directory
import System.IO
import System.Time

d_C_doesFileExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_doesFileExist x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_doesFileExist x1 cd cs

d_C_doesDirectoryExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_doesDirectoryExist x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_doesDirectoryExist x1 cd cs

d_C_getFileSize :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_getFileSize x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_fileSize
  x1 cd cs

d_C_getModificationTime :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Data.Curry_Time.C_ClockTime
d_C_getModificationTime x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_getModificationTime x1 cd cs

d_C_setCurrentDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_setCurrentDirectory x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_setCurrentDirectory x1 cd cs

d_C_getDirectoryContents :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getDirectoryContents x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_getDirectoryContents x1 cd cs

d_C_createDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_createDirectory x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_createDirectory x1 cd cs

d_C_createDirectoryIfMissing :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_createDirectoryIfMissing x1 x2 cd cs = let x3 = Curry_Prelude.d_OP_dollar
                                                 (Data.Curry_List.d_C_scanl1
                                                 (System.Curry_FilePath.d_OP_lt_slash_gt
                                                 cd cs))
                                                 (Curry_Prelude.d_OP_dollar
                                                 System.Curry_FilePath.d_C_splitDirectories
                                                 x2 cd cs) cd cs
  in d_C__case_8 x3 x1 cd cs

d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.OP_Unit cd cs
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_C_doesDirectoryExist x2 cd cs) cd cs)
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16_dot_uscore_hash_lambda2
    x2 x3) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 l cd cs)
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.Directory.createDirectoryIfMissing.createDirs.16" [show x1] info)
  _ -> failCons cd (consFail
    "System.Directory.createDirectoryIfMissing.createDirs.16" (showCons x1))

d_OP_createDirectoryIfMissing_dot_createDirs_dot_16_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_createDirectoryIfMissing_dot_createDirs_dot_16_dot_uscore_hash_lambda2 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C__case_7 x1 x4 cd cs) cd cs)
  (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 x2 cd cs) cd cs

d_C_removeDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_removeDirectory x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_removeDirectory x1 cd cs

d_C_renameDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_renameDirectory x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_renameDirectory) x1
  cd cs) x2 cd cs

d_C_getHomeDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getHomeDirectory cd cs = d_C__case_6 (System.Curry_Environment.d_C_isWindows
  cd cs) cd cs

d_C_getTemporaryDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getTemporaryDirectory cd cs = d_C__case_5
  (System.Curry_Environment.d_C_isWindows cd cs) cd cs

d_C_getAbsolutePath :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_getAbsolutePath x1 cd cs = d_C__case_4 x1 (Curry_Prelude.d_C_apply
  (System.Curry_FilePath.d_C_isAbsolute cd cs) x1 cd cs) cd cs

d_OP_getAbsolutePath_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getAbsolutePath_dot_uscore_hash_lambda5 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_FilePath.d_C_normalise (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x3 cd
  cs) (Curry_Prelude.d_C_drop (Curry_Prelude.C_Int (2)) x1 cd cs) cd cs) cd cs)
  cd cs

d_OP_getAbsolutePath_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getAbsolutePath_dot_uscore_hash_lambda8 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_FilePath.d_C_normalise (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_OP_lt_slash_gt cd cs) x3 cd
  cs) x1 cd cs) cd cs) cd cs

d_C_removeFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_removeFile x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_removeFile x1 cd cs

d_C_renameFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_renameFile x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_renameFile) x1 cd
  cs) x2 cd cs

d_C_copyFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_copyFile x1 x2 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_readFile x1 cd cs) cd cs)
  (Curry_Prelude.d_C_writeFile x2) cd cs

d_C_findFileWithSuffix :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_findFileWithSuffix x1 x2 x3 cd cs = d_C__case_0 x1 x3 x2
  (Curry_Prelude.d_C_apply (System.Curry_FilePath.d_C_isAbsolute cd cs) x1 cd
  cs) cd cs

d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let x5 = Curry_Prelude.d_OP_plus_plus x1 x3 cd
                                       cs
    in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_C_doesFileExist x5 cd cs) cd cs)
    (d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14
    x1 x5 x4) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42 x1 l cd cs)
    (d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42 x1 e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.Directory.findFileWithSuffix.lookupFirstFileWithSuffix.42" [show x1
    , show x2] info)
  _ -> failCons cd (consFail
    "System.Directory.findFileWithSuffix.lookupFirstFileWithSuffix.42" (showCons
    x2))

d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.C_Just x2) cd cs
  Curry_Prelude.C_False -> d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42
    x1 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14
    x1 x2 x3 l cd cs)
    (d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14
    x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x ->
    d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42_dot_uscore_hash_lambda14
    x1 x2 x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory.findFileWithSuffix.lookupFirstFileWithSuffix.42._#lambda14"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "System.Directory.findFileWithSuffix.lookupFirstFileWithSuffix.42._#lambda14"
    (showCons x4))

d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42
    (Curry_Prelude.d_OP_plus_plus x4 (Curry_Prelude.OP_Cons
    (System.Curry_FilePath.d_C_pathSeparator cd cs) x1) cd cs) x2 cd cs) cd cs)
    (d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42_dot_uscore_hash_lambda11
    x1 x5 x2) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 x1 x2 l cd cs)
    (d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 x1 x2 e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.Directory.findFileWithSuffix.lookupFirstFile.42" [show x1, show x2
    , show x3] info)
  _ -> failCons cd (consFail
    "System.Directory.findFileWithSuffix.lookupFirstFile.42" (showCons x3))

d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42_dot_uscore_hash_lambda11 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42_dot_uscore_hash_lambda11 x1 x2 x3 x4 cd cs =
  let x5 = x4
  in Curry_Prelude.d_C_maybe (d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42
  x1 x3 x2 cd cs) (Curry_Prelude.d_OP_dot
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (acceptCs id Curry_Prelude.C_Just) cd cs) x5 cd cs

d_C_getFileWithSuffix :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_getFileWithSuffix x1 x2 x3 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_findFileWithSuffix x1 x2 x3 cd cs) cd cs)
  (d_OP_getFileWithSuffix_dot_uscore_hash_lambda17 x1 x3) cd cs

d_OP_getFileWithSuffix_dot_uscore_hash_lambda17 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_getFileWithSuffix_dot_uscore_hash_lambda17 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "File ")
  (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString " not found in path ") (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_concat cd cs) (Data.Curry_List.d_C_intersperse
  (Curry_Prelude.OP_Cons (System.Curry_FilePath.d_C_searchPathSeparator cd cs)
  Curry_Prelude.OP_List) x2 cd cs) cd cs) cd cs) cd cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x4 cd cs

d_C_prim_doesFileExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_prim_doesFileExist x1 cd cs = external_d_C_prim_doesFileExist x1 cd cs

d_C_prim_doesDirectoryExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_prim_doesDirectoryExist x1 cd cs = external_d_C_prim_doesDirectoryExist x1
  cd cs

d_C_prim_fileSize :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_prim_fileSize x1 cd cs = external_d_C_prim_fileSize x1 cd cs

d_C_prim_getModificationTime :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Data.Curry_Time.C_ClockTime
d_C_prim_getModificationTime x1 cd cs = external_d_C_prim_getModificationTime x1
  cd cs

d_C_getCurrentDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getCurrentDirectory cd cs = external_d_C_getCurrentDirectory cd cs

d_C_prim_setCurrentDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_setCurrentDirectory x1 cd cs = external_d_C_prim_setCurrentDirectory x1
  cd cs

d_C_prim_getDirectoryContents :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_prim_getDirectoryContents x1 cd cs = external_d_C_prim_getDirectoryContents
  x1 cd cs

d_C_prim_createDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_createDirectory x1 cd cs = external_d_C_prim_createDirectory x1 cd cs

d_C_prim_removeDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_removeDirectory x1 cd cs = external_d_C_prim_removeDirectory x1 cd cs

d_C_prim_renameDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_renameDirectory x1 x2 cd cs = external_d_C_prim_renameDirectory x1 x2
  cd cs

d_C_prim_removeFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_removeFile x1 cd cs = external_d_C_prim_removeFile x1 cd cs

d_C_prim_renameFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_renameFile x1 x2 cd cs = external_d_C_prim_renameFile x1 x2 cd cs

d_C__case_8 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C__case_8 x3 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 x3
    cd cs
  Curry_Prelude.C_False -> d_OP_createDirectoryIfMissing_dot_createDirs_dot_16
    (Curry_Prelude.OP_Cons (Data.Curry_List.d_C_last x3 cd cs)
    Curry_Prelude.OP_List) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x3 l cd cs)
    (d_C__case_8 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_8 x3 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_8" [show x3, show x1] info)
  _ -> failCons cd (consFail "System.Directory._case_8" (showCons x1))

d_C__case_7 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C__case_7 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) Curry_Prelude.OP_Unit cd cs
  Curry_Prelude.C_False -> d_C_createDirectory x1 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x1 l cd cs)
    (d_C__case_7 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_7 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_7" [show x1, show x4] info)
  _ -> failCons cd (consFail "System.Directory._case_7" (showCons x4))

d_C__case_6 :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_6 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> System.Curry_Environment.d_C_getEnv
    (Curry_Prelude.toCurryString "USERPROFILE") cd cs
  Curry_Prelude.C_False -> System.Curry_Environment.d_C_getEnv
    (Curry_Prelude.toCurryString "HOME") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 l cd cs)
    (d_C__case_6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_6 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_6" [show x1] info)
  _ -> failCons cd (consFail "System.Directory._case_6" (showCons x1))

d_C__case_5 :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_5 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> System.Curry_Environment.d_C_getEnv
    (Curry_Prelude.toCurryString "TMP") cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (Curry_Prelude.toCurryString "/tmp") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 l cd cs)
    (d_C__case_5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_5 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_5" [show x1] info)
  _ -> failCons cd (consFail "System.Directory._case_5" (showCons x1))

d_C__case_4 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_4 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (System.Curry_FilePath.d_C_normalise x1 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x1 (Curry_Prelude.toCurryString "~") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 l cd cs)
    (d_C__case_4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_4 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_4" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.Directory._case_4" (showCons x2))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_3 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_getHomeDirectory cd cs
  Curry_Prelude.C_False -> d_C__case_2 x1 (Data.Curry_List.d_C_isPrefixOf
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    (Curry_Prelude.toCurryString "~/") x1 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 l cd cs)
    (d_C__case_3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_3 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_3" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.Directory._case_3" (showCons x2))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_2 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_C_getHomeDirectory cd cs) cd cs)
    (d_OP_getAbsolutePath_dot_uscore_hash_lambda5 x1) cd cs
  Curry_Prelude.C_False -> d_C__case_1 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_2 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_2" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.Directory._case_2" (showCons x2))

d_C__case_1 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_1 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
    cd cs) (d_C_getCurrentDirectory cd cs) cd cs)
    (d_OP_getAbsolutePath_dot_uscore_hash_lambda8 x1) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_1 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_1" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.Directory._case_1" (showCons x2))

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_0 x1 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_OP_findFileWithSuffix_dot_lookupFirstFileWithSuffix_dot_42
    x1 x2 cd cs
  Curry_Prelude.C_False -> d_OP_findFileWithSuffix_dot_lookupFirstFile_dot_42 x1
    x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 x3 x2 l cd
    cs) (d_C__case_0 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x1 x3 x2
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Directory._case_0" [show x1, show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "System.Directory._case_0" (showCons x4))

external_d_C_prim_doesFileExist :: Curry_Prelude.C_String -> Cover -> ConstStore
                                -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_doesFileExist s _ _ = toCurry doesFileExist s

external_d_C_prim_doesDirectoryExist :: Curry_Prelude.C_String -> Cover -> ConstStore
                                     -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_doesDirectoryExist s _ _ = toCurry doesDirectoryExist s

external_d_C_prim_fileSize :: Curry_Prelude.C_String -> Cover -> ConstStore
                           -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_prim_fileSize s _ _ = toCurry
  (\f -> do h <- openFile f ReadMode
            i <- hFileSize h
            hClose h
            return i
  ) s

external_d_C_prim_getModificationTime :: Curry_Prelude.C_String -> Cover -> ConstStore
                                      -> Curry_Prelude.C_IO Data.Curry_Time.C_ClockTime
external_d_C_prim_getModificationTime s _ _ = toCurry getModificationTime s

external_d_C_getCurrentDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_String)
external_d_C_getCurrentDirectory _ _ = toCurry getCurrentDirectory

external_d_C_prim_setCurrentDirectory :: Curry_Prelude.C_String -> Cover -> ConstStore
                                      -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_setCurrentDirectory s _ _ = toCurry setCurrentDirectory s

external_d_C_prim_getDirectoryContents :: Curry_Prelude.C_String -> Cover -> ConstStore
                                       -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.C_String))
external_d_C_prim_getDirectoryContents s _ _ = toCurry getDirectoryContents s

external_d_C_prim_createDirectory :: Curry_Prelude.C_String -> Cover -> ConstStore
                                  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_createDirectory s _ _ = toCurry createDirectory s

external_d_C_prim_removeFile :: Curry_Prelude.C_String -> Cover -> ConstStore
                             -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_removeFile s _ _ = toCurry removeFile s

external_d_C_prim_removeDirectory :: Curry_Prelude.C_String -> Cover -> ConstStore
                                  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_removeDirectory s _ _ = toCurry removeDirectory s

external_d_C_prim_renameFile :: Curry_Prelude.C_String -> Curry_Prelude.C_String -> Cover -> ConstStore
                             -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_renameFile s1 s2 _ _ = toCurry renameFile s1 s2

external_d_C_prim_renameDirectory :: Curry_Prelude.C_String -> Curry_Prelude.C_String
                                  -> Cover -> ConstStore 
                                  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_renameDirectory s1 s2 _ _= toCurry renameDirectory s1 s2
