{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif
{-# LANGUAGE MultiParamTypeClasses #-}

module System.Curry_IOExts
  ( d_C_execCmd
  , d_C_evalCmd
  , d_C_connectToCommand
  , d_C_readCompleteFile
  , d_C_updateFile
  , nd_C_updateFile
  , d_C_exclusiveIO
  , nd_C_exclusiveIO )
  where

import Basics
import qualified Curry_Prelude
import qualified System.Curry_IO
import qualified System.Curry_Process

import Data.IORef
import System.Process     (readProcessWithExitCode, runInteractiveCommand)
import Control.Concurrent (forkIO)
import System.IO

d_C_execCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 System.Curry_IO.C_Handle
  System.Curry_IO.C_Handle System.Curry_IO.C_Handle)
d_C_execCmd x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_execCmd x1
  cd cs

d_C_evalCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_evalCmd x1 x2 x3 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (Curry_Prelude.d_OP_dollar_hash_hash
  (acceptCs (acceptCs id) d_C_prim_evalCmd) x1 cd cs) x2 cd cs) x3 cd cs

d_C_connectToCommand :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO System.Curry_IO.C_Handle
d_C_connectToCommand x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_connectToCmd x1 cd cs

d_C_readCompleteFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_readCompleteFile x1 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_C_readFile x1 cd cs) cd cs)
  d_OP_readCompleteFile_dot_uscore_hash_lambda2 cd cs

d_OP_readCompleteFile_dot_f_dot_8 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t1 -> t0 -> Cover
  -> ConstStore -> t0
d_OP_readCompleteFile_dot_f_dot_8 x1 x2 cd cs = case x1 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.OP_Cons x3 x4 -> d_OP_readCompleteFile_dot_f_dot_8 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readCompleteFile_dot_f_dot_8 l x2 cd cs)
    (d_OP_readCompleteFile_dot_f_dot_8 r x2 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readCompleteFile_dot_f_dot_8 z x2 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_readCompleteFile_dot_f_dot_8 e x2 cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.IOExts.readCompleteFile.f.8" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.IOExts.readCompleteFile.f.8" (showCons x1))

d_OP_readCompleteFile_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readCompleteFile_dot_uscore_hash_lambda2 x1 cd cs = let x2 = x1
  in d_OP_readCompleteFile_dot_f_dot_8 x2 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x2 cd cs) cd cs

d_C_updateFile :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_updateFile x1 x2 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_readCompleteFile x2 cd cs) cd cs)
  (d_OP_updateFile_dot_uscore_hash_lambda5 x2 x1) cd cs

nd_C_updateFile :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
nd_C_updateFile x1 x2 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) (d_C_readCompleteFile x2 cd cs) s1 cd cs)) (wrapNX id
  (nd_OP_updateFile_dot_uscore_hash_lambda5 x2 x1)) s3 cd cs))

d_OP_updateFile_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_updateFile_dot_uscore_hash_lambda5 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Prelude.d_C_writeFile x1 (Curry_Prelude.d_C_apply x2 x4 cd cs) cd cs

nd_OP_updateFile_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
nd_OP_updateFile_dot_uscore_hash_lambda5 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` (let x4 = x3
  in Curry_Prelude.d_C_writeFile x1 (Curry_Prelude.nd_C_apply x2 x4 s0 cd cs) cd
  cs)

d_C_exclusiveIO :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_IO t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO t0
d_C_exclusiveIO x1 x2 cd cs = let x3 = Curry_Prelude.d_OP_dollar
                                    System.Curry_Process.d_C_system
                                    (Curry_Prelude.d_OP_plus_plus
                                    (Curry_Prelude.toCurryString
                                    "lockfile-remove --lock-name ") x1 cd cs) cd
                                    cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (Curry_Prelude.d_OP_dollar System.Curry_Process.d_C_system
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
  "lockfile-create --lock-name ") x1 cd cs) cd cs) cd cs)
  (Curry_Prelude.d_C_catch (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x2 cd cs) (d_OP_exclusiveIO_dot_uscore_hash_lambda8 x3) cd cs)
  (d_OP_exclusiveIO_dot_uscore_hash_lambda10 x3) cd cs) cd cs

nd_C_exclusiveIO :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_IO t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
nd_C_exclusiveIO x1 x2 s cd cs = let s16 = s
  in s16 `seq` (let s0 = leftSupply s16
                    s14 = rightSupply s16
  in s0 `seq` (s14 `seq` (let x3 = Curry_Prelude.nd_OP_dollar (wrapDX id
                                System.Curry_Process.d_C_system)
                                (Curry_Prelude.d_OP_plus_plus
                                (Curry_Prelude.toCurryString
                                "lockfile-remove --lock-name ") x1 cd cs) s0 cd
                                cs
  in let s13 = leftSupply s14
         s15 = rightSupply s14
         s4 = leftSupply s15
         s12 = rightSupply s15
  in s13 `seq` (s15 `seq` (s4 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
  (let s3 = leftSupply s4
       s5 = rightSupply s4
       s1 = leftSupply s5
       s2 = rightSupply s5
  in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s1 cd cs) (Curry_Prelude.nd_OP_dollar (wrapDX id
  System.Curry_Process.d_C_system) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "lockfile-create --lock-name ") x1 cd cs) s2 cd
  cs) s3 cd cs)))) (let s11 = leftSupply s12
                        s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_C_catch (let s9 = leftSupply s10
                                                        s8 = rightSupply s10
  in s9 `seq` (s8 `seq` Curry_Prelude.nd_C_apply (let s7 = leftSupply s8
                                                      s6 = rightSupply s8
  in s7 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s6 cd cs) x2 s7 cd cs)) (wrapNX id (nd_OP_exclusiveIO_dot_uscore_hash_lambda8
  x3)) s9 cd cs)) (wrapNX id (nd_OP_exclusiveIO_dot_uscore_hash_lambda10 x3))
  s11 cd cs)) s13 cd cs))))))

d_OP_exclusiveIO_dot_uscore_hash_lambda8 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO t0
d_OP_exclusiveIO_dot_uscore_hash_lambda8 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x1 cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x3 cd cs) cd cs

nd_OP_exclusiveIO_dot_uscore_hash_lambda8 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO t0
nd_OP_exclusiveIO_dot_uscore_hash_lambda8 x1 x2 s cd cs = let s7 = s
  in s7 `seq` (let x3 = x2
  in let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) x1 s1 cd cs)) (let s4 = leftSupply s5
                               s3 = rightSupply s5
  in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s3 cd cs) x3 s4 cd cs)) s6 cd cs))))

d_OP_exclusiveIO_dot_uscore_hash_lambda10 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> Curry_Prelude.C_IOError
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_OP_exclusiveIO_dot_uscore_hash_lambda10 x1 x2 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) x1 cd cs) (Curry_Prelude.d_C_ioError x2 cd cs) cd cs

nd_OP_exclusiveIO_dot_uscore_hash_lambda10 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> Curry_Prelude.C_IOError
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
nd_OP_exclusiveIO_dot_uscore_hash_lambda10 x1 x2 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  s0 cd cs) x1 s1 cd cs)) (Curry_Prelude.d_C_ioError x2 cd cs) s3 cd cs))

d_C_prim_execCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3
  System.Curry_IO.C_Handle System.Curry_IO.C_Handle System.Curry_IO.C_Handle)
d_C_prim_execCmd x1 cd cs = external_d_C_prim_execCmd x1 cd cs

d_C_prim_evalCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_prim_evalCmd x1 x2 x3 cd cs = external_d_C_prim_evalCmd x1 x2 x3 cd cs

d_C_prim_connectToCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO System.Curry_IO.C_Handle
d_C_prim_connectToCmd x1 cd cs = external_d_C_prim_connectToCmd x1 cd cs

external_d_C_prim_execCmd :: Curry_Prelude.C_String -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 System.Curry_IO.C_Handle System.Curry_IO.C_Handle System.Curry_IO.C_Handle)
external_d_C_prim_execCmd str _ _ = toCurry
  (\s -> do (h1,h2,h3,_) <- runInteractiveCommand s
            return (OneHandle h1, OneHandle h2, OneHandle h3)) str

external_d_C_prim_evalCmd :: Curry_Prelude.C_String -> Curry_Prelude.OP_List Curry_Prelude.C_String -> Curry_Prelude.C_String
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_String Curry_Prelude.C_String)
external_d_C_prim_evalCmd cmd args input _ _
  = toCurry readProcessWithExitCode cmd args input

external_d_C_prim_connectToCmd :: Curry_Prelude.C_String -> Cover -> ConstStore
                               -> Curry_Prelude.C_IO System.Curry_IO.C_Handle
external_d_C_prim_connectToCmd str _ _ = toCurry
  (\s -> do (hin,hout,herr,_) <- runInteractiveCommand s
            forkIO (forwardError herr)
            return (InOutHandle hout hin)) str

forwardError :: Handle -> IO ()
forwardError h = do
   eof <- hIsEOF h
   if eof then return ()
          else hGetLine h >>= hPutStrLn stderr >> forwardError h


-----------------------------------------------------------------------
